/*********************************************/
/* Example Program for ET-ADuC847 STAMP V1.0 */
/* MCU      : ADuC847(XTAL = 32.768 KHz)     */
/*          : Frequency Bus = 12.582912 MHz  */
/* Compiler : Keil C51 (V7.50)               */
/* Function : Demo RS232 Receiced & Transmit */
/* Write By : ETT CO.,LTD.(May/2011)         */
/*********************************************/

/* include  section */
#include <aduc847.h>				// ADUC847 SFR : File
#include <stdio.h>                	// Prototype declarations for I/O functions

/*--------------------------------------------
The main C function.  Program execution Here 
---------------------------------------------*/
void main (void) 
{  
  char ch;
   
  PLLCON = 0x00;					// Initial Clock = 12.582912MHz

  /* Initial MCS51 Serial Port */
  /* Used Timer3 Gen. Baudrate */
  // Baud   = T3CON,T3FD
  // 9600   = 0x86,0x12
  // 19200  = 0x85,0x12
  // 38400  = 0x84,0x12
  // 57600  = 0x83,0x2D
  // 115200 = 0x82,0x2D
  // 230400 = 0x81,0x2D
  T3CON = 0x86;						// 9600BPS/12.58MHz(32.768KHz+PLL)
  T3FD  = 0x12;        
  SCON  = 0x50;  					// Serial Port Mode 1 (N,8,1)
  ES    = 0;     					// Disable Serial Interupt            
  TI    = 1;     					// Set TI to send First char of Keil-UART Function

  /* Print Message to RS232 */
  printf("\nHello World From ET-ADuC847 STAMP V1.0");  
  printf("\n>");

  while (1) 
  {
    ch = getkey();
	if(ch==0x0D)
	{
	  printf("\n>ET-ADuC847 STAMP V1.0");  
	  printf("\n>");
	}
	else
	{
      putchar(ch);  							
	}
  }	    
}

